 IF EXISTS (SELECT * FROM SYS.objects WHERE NAME = 'V_ENVIA_PRODUTOS_FISCO_ESTOQUE')
BEGIN
	DROP VIEW  V_ENVIA_PRODUTOS_FISCO_ESTOQUE;
END 
GO 

CREATE VIEW  V_ENVIA_PRODUTOS_FISCO_ESTOQUE
AS 
	  SELECT	 DISTINCT
			 EST_FECHA.CD_EMP
			,EST_FECHA.CD_FILIAL
			,EST_FECHA.MES_FECHA
			,EST_FECHA.ANO_FECHA
			,EST_PROD.CD_PROD
			,EST_PROD.DS_PROD
			,COALESCE(( SELECT TOP 1 EST_PROD_CD_BARRA.CD_BARRA
						  FROM EST_PROD_CD_BARRA
						 WHERE EST_PROD.CD_EMP = EST_PROD_CD_BARRA.CD_EMP
						   AND EST_PROD.CD_PROD = EST_PROD_CD_BARRA.CD_PROD  
						), '' ) AS CD_BARRA
			,EST_FECHA.QT_EST
			,EST_FECHA.QT_ENT
			,EST_FECHA.VLR_VD
			,PRC_FILIAL.ALIQ_ICMS
		 	,COALESCE(EST_TRIB.ICMS, 0 )			AS ICMS
			,COALESCE(EST_TRIB.SUBS_TRIB, 0 )		AS SUBS_TRIB
			,COALESCE(EST_TRIB.ICMS_RD, 0 )			AS ICMS_RD
			,COALESCE(EST_TRIB.ISENTO, 0 )			AS ISENTO
			,COALESCE(EST_TRIB.SUBS_TRIB_ANT, 0 )	AS SUBS_TRIB_ANT
		 	,COALESCE(EST_TRIB.FLAG_OUTROS, 0 )		AS FLAG_OUTROS
			,EST_TRIB.CD_TRIB_FC
			,COALESCE(EST_PROD_UN_MED.DS_UN, 'UN' )		AS DS_UN
			,EST_PROD_CPL.TP_PROD
			,CASE WHEN COALESCE(EST_PROD.NR_CEST, ''  )  = ''  THEN 'SEM CEST' 
				  ELSE EST_PROD.NR_CEST
			  END										AS NR_CEST
			,EST_PROD.NR_SERV
			,EST_PROD.NR_NCM
	   FROM EST_FECHA    
		    JOIN EST_PROD ON EST_FECHA.CD_EMP = EST_PROD.CD_EMP
						 AND EST_FECHA.CD_PROD= EST_PROD.CD_PROD
		    JOIN EST_PROD_CPL ON EST_FECHA.CD_EMP    = EST_PROD_CPL.CD_EMP
							 AND EST_FECHA.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
							 AND EST_FECHA.CD_PROD   = EST_PROD_CPL.CD_PROD
			JOIN  EST_PROD_CPL_TRIB_EST ON EST_PROD_CPL.CD_EMP    = EST_PROD_CPL_TRIB_EST.CD_EMP   
								       AND EST_PROD_CPL.CD_FILIAL = EST_PROD_CPL_TRIB_EST.CD_FILIAL   
								       AND EST_PROD_CPL.CD_PROD   = EST_PROD_CPL_TRIB_EST.CD_PROD  
		    JOIN EST_TRIB ON EST_PROD_CPL_TRIB_EST.CD_TRIB = EST_TRIB.CD_TRIB 
		    JOIN PRC_FILIAL ON EST_FECHA.CD_EMP    = PRC_FILIAL.CD_EMP
						   AND EST_FECHA.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		    LEFT JOIN EST_PROD_UN_MED ON EST_PROD.CD_UN_VD = EST_PROD_UN_MED.CD_CTR_UN
	  WHERE EST_PROD_CPL.TP_PROD NOT IN (10,11)
	    AND EST_FECHA.QT_EST > 0 
	
    
